﻿using HIPS.Web.Components.Common;

namespace HIPS.Web.Components.ServiceModel
{

    /// <summary>
    /// Represents a textual response message.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
    /// </history>
    public class ResponseMessage
    {

        #region Properties

        /// <summary>
        /// Gets or sets the level associated with the message.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
        /// </history>
        public MessageLevel Level { get; set; }

        /// <summary>
        /// Gets or sets the description text for the message.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
        /// </history>
        public string Description { get; set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
        /// </history>
        public ResponseMessage()
        {
        }

        /// <summary>
        /// Creates a new response message.
        /// </summary>
        /// <param name="description">Description text for the message.</param>
        /// <param name="level">Level associated with the message.</param>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="23 November 2013">Initial version.</change>
        /// </history>
        public ResponseMessage(string description, MessageLevel level) : this()
        {
            this.Description = description;
            this.Level = level;
        }

        #endregion

    }

}
